﻿
CREATE PROCEDURE [App].[NVCC_usp_GetPatientBySid]
	@pid int   --PatientSID

-- NOTICE:
-- Do not edit the stored procedure live on the server. Code to generate
-- the procedures is stored in the project repository. Any changes made
-- that are not recorded in the repository will be overwritten.

AS
--==================================================================================
--Requestor             : Non Va Coordinated Care Project
--Author                : Jon Duckart (Original script by Dr. Charles Demosthenes)
--Object/SP Name        : NVCC_usp_GetPatientBySid
--Server                : 
--Data Base             : CC_REFDOC
--Schema                : app
--Report                : N/A
--Folder                : N/A
--Report Loc            : N/A
--Job                   : None
--Job Loc               : None
--Note                  : 
--Date Created          : 04-14-2016
--
--Last Changed          : 06-22-2016
--Last Changed By		: Brian Diggs - Northwest Innovation Center (NWIC)
--Reason For Change		: Formatting and idempotence and signing
--
--Purpose               : To retrieve a single patient record for the NVCC app by SID.
--==================================================================================
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
   SET NOCOUNT ON;

   --  SELECT  [PatientSID]
 --     ,[PatientIEN]
 --     ,[Sta3n] as Station
 --     ,[PatientName]
 --     ,[PatientLastName]
 --     ,[PatientFirstName]
 --     ,[PatientSSN]
 --     ,[ScrSSN]
 --     ,[StreetAddress1]
 --     ,[StreetAddress2]
 --     ,[StreetAddress3]
 --     ,[City]
 --     ,[Zip]
 --     ,[Zip4]
 --     ,[PostalCode]
 --     ,[Province]
 --     ,[CountrySID]
 --     ,[Country]
 --     ,[PhoneResidence]
 --     ,[PhoneWork]
 --     ,[PhoneCellular]
 --     ,[MothersMaidenName]
 --     ,[DateOfDeath]
 --     ,[DateOfDeathText]
 --     ,[EmailAddress]
 --     ,[BadAddressIndicator]
 --     ,[ExcludeFromFacilityDirectoryFlag]
 --     ,[AddressChangeInstitutionSID]
 --     ,[AddressChangeStaffSID]
 --     ,[NOKPrimaryChangeDateTime]
 --     ,[NOKPrimaryChangeVistaErrorDate]
 --     ,[NOKPrimaryChangeDateTimeTransformSID]
 --     ,[NOKSecondaryChangeDateTime]
 --     ,[NOKSecondaryChangeVistaErrorDate]
 --     ,[NOKSecondaryChangeDateTimeTransformSID]
 --     ,[NOKRelationshipToPatient]
 --     ,[NOKDesigneeSameAsFlag]
 --     ,[NOKEmergencyContactSameAsFlag]
 --     ,[TemporaryAddressActiveFlag]
 --     ,[TemporaryAddressLastEditedDateTime]
 --     ,[TemporaryAddressLastEditedVistaErrorDate]
 --     ,[TemporaryAddressLastEditedDateTimeTransformSID]
 --     ,[TemporaryAddressChangeInstitutionSID]
 --     ,[TemporaryAddressStartDate]
 --     ,[TemporaryAddressStartVistaErrorDate]
 --     ,[TemporaryAddressStartDateTransformSID]
 --     ,[TemporaryAddressEndDate]
 --     ,[TemporaryAddressEndVistaErrorDate]
 --     ,[TemporaryAddressEndDateTransformSID]
 --     ,[ConfidentialAddressActiveFlag]
 --     ,[CDFlag]
 --     ,[CDDecidedByName]
 --     ,[CDDecisionDate]
 --     ,[CDDecisionVistaErrorDate]
 --     ,[CDDecisionDateTransformSID]
 --     ,[CDReviewedDate]
 --     ,[CDReviewedVistaErrorDate]
 --     ,[CDReviewedDateTransformSID]
 --     ,[CDDeterminingInstitutionSID]
 --     ,[CDDeterminationType]
 --     ,[CurrentPurpleHeartDecisionType]
 --     ,[CurrentPurpleHeartStatus]
 --     ,[PurpleHeartInstitutionSID]
 --     ,[MedicaidNumber]
 --     ,[RaceSID]
 --     ,[Gender]
 --     ,[Age]
 --     ,[StateSID]
 --     ,[State]
 --     ,[County]
 --     ,[Deceased]
 --     ,[PatientICN]
 --     ,[PatientICNChecksum]
 --     ,[PseudoSSNFlag]
 --     ,[PeriodOfServiceSID]
 --     ,[PeriodOfService]
 --     ,[CurrentMeansTestStatusSID]
 --     ,[MaritalStatusSID]
 --     ,[MaritalStatus]
 --     ,[PercentServiceConnect]
 --     ,[InsuranceCoverageFlag]
 --     ,[ReligionSID]
 --     ,[Religion]
 --     ,[AgentOrangeExposureFlag]
 --     ,[AgentOrangeLocationCode]
 --     ,[RadiationExposureCode]
 --     ,[IonizingRadiationExposureFlag]
 --     ,[SHADFlag]
 --     ,[VeteranFlag]
 --     ,[CombatFlag]
 --     ,[CombatEligibilityEndDate]
 --     ,[CombatEligibilityEndVistaErrorDate]
 --     ,[CombatEligibilityEndDateTransformSID]
 --     ,[TestPatientFlag]
 --     ,[CDWPossibleTestPatientFlag]
 --     ,[SpinalCordInjuryType]
 --     ,[EnteredIntoFileDate]
 --     ,[EnteredIntoFileVistaErrorDate]
 --     ,[EnteredIntoFileDateTransformSID]
 --     ,[EmergencyResponseIndicator]
 --     ,[EligibilitySID]
 --     ,[Eligibility]
 --     ,[EligibilityVACode]
 --     ,[DateOfBirth]
 --     ,[DateOfBirthText]
 --     ,[SensitiveFlag]
 --     ,[LastServiceEntryDate]
 --     ,[LastServiceEntryVistaErrorDate]
 --     ,[LastServiceEntryDateTransformSID]
 --     ,[LastServiceSeparationDate]
 --     ,[LastServiceSeparationVistaErrorDate]
 --     ,[LastServiceSeparationDateTransformSID]
 --     ,[PreferredInstitutionSID]
 --     ,[POWFlag]
 --     ,[POWLocationSID]
 --     ,[POWFromVistaDate]
 --     ,[POWToVistaDate]
 --     ,[CombatFromVistaDate]
 --     ,[CombatToVistaDate]
 --     ,[ClaimNumber]
 --     ,[RoomBedSID]
 --     ,[IneligibleDate]
 --     ,[IneligibleVistaErrorDate]
 --     ,[IneligibleDateTransformSID]
 --     ,[IneligibleReason]
 --     ,[EligibilityStatus]
 --     ,[EligibilityVerificationSource]
 --     ,[GISLocatorName]
 --     ,[GISMatchStatusCode]
 --     ,[GISMatchScore]
 --     ,[GISMatchMethodCode]
 --     ,[GISMatchedAddress]
 --     ,[GISAddressType]
 --     ,[GISStreetSide]
 --     ,[GISPatientAddressLongitude]
 --     ,[GISPatientAddressLatitude]
 --     ,[GISAddressUpdatedDate]
 --     ,[GISFIPSCode]
 --     ,[GISMarket]
 --     ,[GISSubmarket]
 --     ,[GISSector]
 --     ,[GISURH]
 --     ,[GISCongressDistrict]
 --  FROM  CDWWork.SPatient.SPatient
	--WHERE
	--	PatientSid= @pid
	--	AND patientname <>'*Unknown at this time*'
	--	AND patientname is not null;


	  SELECT
	   a.[PatientSID]
      ,a.[PatientIEN]
      ,a.[Sta3n] as Station
      ,a.[PatientName]
      ,a.[PatientLastName]
      ,a.[PatientFirstName]
      ,a.[PatientSSN]
      ,a.[ScrSSN]
      ,b.[StreetAddress1]
      ,b.[StreetAddress2]
      ,b.[StreetAddress3]
      ,b.[City]
      ,b.[Zip]
      ,b.[Zip4]
      ,b.[PostalCode]
      ,b.[Province]
      ,null as [CountrySID]
      ,b.[Country]
      ,c.[PhoneNumber] as [PhoneResidence]
      ,d.[WorkPhoneNumber] as [PhoneWork]
      ,e.[PhoneNumber] as [PhoneCellular]
      ,f.MotherMaidenName as [MothersMaidenName]
      ,a.DeathDateTime as [DateOfDeath]
      ,null as [DateOfDeathText]
      ,h.[EmailAddress]
      ,b.[BadAddressIndicator]
      ,null as [ExcludeFromFacilityDirectoryFlag]
      ,b.[AddressChangeInstitutionSID]
      ,b.[AddressChangeStaffSID]
      ,i.AddressChangeDateTime as [NOKPrimaryChangeDateTime]
      ,i.AddressChangeVistaErrorDate as [NOKPrimaryChangeVistaErrorDate]
      ,i.AddressChangeDateTimeTransformSID as [NOKPrimaryChangeDateTimeTransformSID]
      ,j.AddressChangeDateTime as [NOKSecondaryChangeDateTime]
      ,j.AddressChangeVistaErrorDate as [NOKSecondaryChangeVistaErrorDate]
      ,j.AddressChangeDateTimeTransformSID as [NOKSecondaryChangeDateTimeTransformSID]
      ,i.NameOfContact as [NOKRelationshipToPatient]
      ,null as [NOKDesigneeSameAsFlag]
      ,null as [NOKEmergencyContactSameAsFlag]
      ,null as [TemporaryAddressActiveFlag]
      ,k.AddressChangeDateTime as [TemporaryAddressLastEditedDateTime]
      ,k.AddressChangeVistaErrorDate as [TemporaryAddressLastEditedVistaErrorDate]
      ,k.AddressChangeDateTimeTransformSID as [TemporaryAddressLastEditedDateTimeTransformSID]
      ,k.AddressChangeInstitutionSID as [TemporaryAddressChangeInstitutionSID]
      ,k.AddressStartDateTime as [TemporaryAddressStartDate]
      ,k.AddressStartVistaErrorDate as [TemporaryAddressStartVistaErrorDate]
      ,k.AddressStartDateTimeTransformSID as [TemporaryAddressStartDateTransformSID]
      ,k.AddressEndDateTime as [TemporaryAddressEndDate]
      ,k.AddressEndVistaErrorDate as [TemporaryAddressEndVistaErrorDate]
      ,k.AddressEndDateTimeTransformSID as [TemporaryAddressEndDateTransformSID]
      ,null as [ConfidentialAddressActiveFlag]
      ,null as [CDFlag]
      ,null as [CDDecidedByName]
      ,l.DecisionDateTime as [CDDecisionDate]
      ,l.DecisionVistaErrorDate as [CDDecisionVistaErrorDate]
      ,l.DecisionDateTimeTransformSID as [CDDecisionDateTransformSID]
      ,l.ReviewDateTime as [CDReviewedDate]
      ,l.ReviewVistaErrorDate as [CDReviewedVistaErrorDate]
      ,l.ReviewDateTimeTransformSID as [CDReviewedDateTransformSID]
      ,l.DeterminingInstitutionSID as [CDDeterminingInstitutionSID]
      ,l.MethodOfDetermination as [CDDeterminationType]
      ,null as [CurrentPurpleHeartDecisionType]
      ,m.PurpleHeartStatus as [CurrentPurpleHeartStatus]
      ,null as [PurpleHeartInstitutionSID]
      ,a.[MedicaidNumber]
      ,n.LegacyRaceSID as [RaceSID]
      ,a.[Gender]
      ,a.[Age]
      ,b.[StateSID]
      ,b.[State]
      ,b.[County]
      ,a.DeceasedFlag as [Deceased]
      ,a.[PatientICN]
      ,null as [PatientICNChecksum]
      ,a.PseudoSSNReason as [PseudoSSNFlag]
      ,a.PseudoSSNReason as [PeriodOfServiceSID]
      ,a.[PeriodOfService]
      ,a.[CurrentMeansTestStatusSID]
      ,a.[MaritalStatusSID]
      ,a.[MaritalStatus]
      ,o.ServiceConnectedPercent as [PercentServiceConnect]
      ,a.[InsuranceCoverageFlag]
      ,a.[ReligionSID]
      ,a.[Religion]
      ,o.AgentOrangeExposureCode as [AgentOrangeExposureFlag]
      ,o.AgentOrangeLocation as [AgentOrangeLocationCode]
      ,o.IonizingRadiationCode as [RadiationExposureCode]
      ,o.IonizingRadiationExposureCode as [IonizingRadiationExposureFlag]
      ,o.[SHADFlag]
      ,a.[VeteranFlag]
      ,o.CombatServiceFlag as [CombatFlag]
      ,o.CombatEligibilityEndDateTime as [CombatEligibilityEndDate]
      ,o.[CombatEligibilityEndVistaErrorDate]
      ,o.CombatEligibilityEndDateTimeTransformSID as [CombatEligibilityEndDateTransformSID]
      ,a.[TestPatientFlag]
      ,a.[CDWPossibleTestPatientFlag]
      ,o.SpinalCordInjuryCode as [SpinalCordInjuryType]
      ,a.PatientEnteredDateTime as [EnteredIntoFileDate]
      ,a.PatientEnteredVistaErrorDate as [EnteredIntoFileVistaErrorDate]
      ,a.PatientEnteredDateTimeTransformSID as [EnteredIntoFileDateTransformSID]
      ,a.[EmergencyResponseIndicator]
      ,a.[EligibilitySID]
      ,a.[Eligibility]
      ,a.[EligibilityVACode]
      ,a.BirthDateTime as [DateOfBirth]
      ,null as [DateOfBirthText]
      ,a.[SensitiveFlag]
      ,p.ServiceEntryDateTime as [LastServiceEntryDate]
      ,p.ServiceEntryVistaErrorDate as [LastServiceEntryVistaErrorDate]
      ,p.ServiceEntryDateTimeTransformSID as [LastServiceEntryDateTransformSID]
      ,p.ServiceSeparationDateTime as [LastServiceSeparationDate]
      ,p.ServiceSeparationDateTimeVistaErrorDate as [LastServiceSeparationVistaErrorDate]
      ,p.ServiceSeparationDateTimeTransformSID as [LastServiceSeparationDateTransformSID]
      ,a.[PreferredInstitutionSID]
      ,o.POWStatusCode as [POWFlag]
      ,o.[POWLocationSID]
      ,o.POWStartDateTime as [POWFromVistaDate]
      ,o.POWEndDateTime as [POWToVistaDate]
      ,o.CombatServiceStartDateTime as [CombatFromVistaDate]
      ,o.CombatServiceEndDateTime as [CombatToVistaDate]
      ,o.[ClaimNumber]
      ,null as [RoomBedSID]
      ,a.IneligibleDateTime as [IneligibleDate]
      ,a.[IneligibleVistaErrorDate]
      ,a.IneligibleDateTimeTransformSID as [IneligibleDateTransformSID]
      ,a.[IneligibleReason]
      ,a.[EligibilityStatus]
      ,a.[EligibilityVerificationSource]
      ,b.[GISLocatorName]
      ,b.[GISMatchStatusCode]
      ,b.[GISMatchScore]
      ,b.[GISMatchMethodCode]
      ,b.[GISMatchedAddress]
      ,b.[GISAddressType]
      ,b.[GISStreetSide]
      ,b.[GISPatientAddressLongitude]
      ,b.[GISPatientAddressLatitude]
      ,b.[GISAddressUpdatedDate]
      ,b.[GISFIPSCode]
      ,b.[GISMarket]
      ,b.[GISSubmarket]
      ,b.[GISSector]
      ,b.[GISURH]
      ,b.[GISCongressDistrict]
   FROM  CDWWork.SPatient.SPatient a 
   Left join CDWWork.SPatient.SPatientAddress b on a.PatientSID = b.PatientSID and b.OrdinalNumber = 13
   left join CDWWork.Spatient.SpatientPhone c on a.PatientSID = c.PatientSID and c.OrdinalNumber = 13
   left join CDWWork.Spatient.SpatientPhone d on a.PatientSID = d.PatientSID and d.OrdinalNumber = 9
   left join CDWWork.Spatient.SpatientPhone e on a.PatientSID = e.PatientSID and e.OrdinalNumber = 14
   left join CDWWork.Spatient.PlaceOfBirth f on a.PatientSID = f.PatientSID
   left join CDWWork.Spatient.SpatientPhone h on a.PatientSID = h.PatientSID and h.OrdinalNumber = 16
   left join CDWWork.Spatient.SpatientAddress i on a.PatientSID = i.PatientSID and i.OrdinalNumber = 2
   left join CDWWork.Spatient.SpatientAddress j on a.PatientSID = j.PatientSID and j.OrdinalNumber = 3
   left join CDWWork.Spatient.SpatientAddress k on a.PatientSID = k.PatientSID and k.OrdinalNumber = 4
   Left join CDWWork.Patient.CatastrophicDisabilityHistory l on a.PatientSID = l.PatientSID
   Left join CDWWork.Patient.PurpleHeart m on a.PatientSID = m.PatientSID
   left join CDWWork.Patsub.PatientRace n on a.PatientSID = n.PatientSID
   Left join CDWWork.Spatient.SPatientDisability o on a.PatientSID = o.PatientSID
   Left join CDWWork.Spatient.MilitaryServiceEpisodeLegacy p on a.PatientSID = p.PatientSID and p.OrdinalNumber = 1
	WHERE
		a.PatientSid= @pid
		AND patientname <>'*Unknown at this time*'
		AND patientname is not null;

END;

